IF OBJECT_ID('EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO') IS NULL
BEGIN
	CREATE TABLE EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO (
		CD_EMP INT NOT NULL,
		CD_FILIAL INT NOT NULL,
		CD_PROD INT NOT NULL,
		QTDE_ARREDOND MONEY NOT NULL,
		ORDEM INT NOT NULL,
		CD_USU INT NOT NULL,
		DT_CAD DATE NOT NULL,
		DT_ULT_ALT DATETIME NOT NULL,
		CONSTRAINT PK_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO PRIMARY KEY (CD_EMP, CD_FILIAL, CD_PROD))

END

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE NAME = 'FK_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_EST_PROD') 
BEGIN
	ALTER TABLE EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO ADD CONSTRAINT FK_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_EST_PROD FOREIGN KEY (CD_EMP, CD_PROD) REFERENCES EST_PROD (CD_EMP, CD_PROD)
END

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE NAME = 'FK_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_PRC_FILIAL') 
BEGIN
	ALTER TABLE EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO ADD CONSTRAINT FK_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_PRC_FILIAL FOREIGN KEY (CD_EMP, CD_FILIAL) REFERENCES PRC_FILIAL (CD_EMP, CD_FILIAL)
END

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE NAME = 'FK_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_GLB_USU') 
BEGIN
	ALTER TABLE EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO ADD CONSTRAINT FK_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_GLB_USU FOREIGN KEY (CD_USU) REFERENCES GLB_USU (CD_USU)
END

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_ORDEM') 
BEGIN
	ALTER TABLE EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO ADD CONSTRAINT DF_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_ORDEM DEFAULT 0 FOR ORDEM
END


IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_DT_CAD') 
BEGIN
	ALTER TABLE EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO ADD CONSTRAINT DF_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_DT_CAD DEFAULT GETDATE() FOR DT_CAD
END

IF NOT EXISTS (SELECT * FROM SYS.DEFAULT_CONSTRAINTS WHERE NAME = 'DF_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_DT_ULT_ALT') 
BEGIN
	ALTER TABLE EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO ADD CONSTRAINT DF_EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_DT_ULT_ALT DEFAULT GETDATE() FOR DT_ULT_ALT
END

